/*
 * Decompiled with CFR 0.152.
 */
package androidx.slice.builders;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.Context;
import android.net.Uri;
import android.os.PersistableBundle;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.graphics.drawable.IconCompat;
import androidx.core.util.Pair;
import androidx.remotecallback.RemoteCallback;
import androidx.slice.Slice;
import androidx.slice.SliceSpecs;
import androidx.slice.builders.GridRowBuilder;
import androidx.slice.builders.SelectionBuilder;
import androidx.slice.builders.SliceAction;
import androidx.slice.builders.TemplateSliceBuilder;
import androidx.slice.builders.impl.ListBuilderBasicImpl;
import androidx.slice.builders.impl.ListBuilderImpl;
import androidx.slice.builders.impl.TemplateBuilderImpl;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@RequiresApi(value=19)
public class ListBuilder
extends TemplateSliceBuilder {
    private boolean mHasSeeMore;
    private androidx.slice.builders.impl.ListBuilder mImpl;
    public static final int ACTION_WITH_LABEL = 6;
    public static final int ICON_IMAGE = 0;
    public static final int SMALL_IMAGE = 1;
    public static final int LARGE_IMAGE = 2;
    public static final int RAW_IMAGE_SMALL = 3;
    public static final int RAW_IMAGE_LARGE = 4;
    public static final int UNKNOWN_IMAGE = 5;
    public static final long INFINITY = -1L;
    public static final int RANGE_MODE_STAR_RATING = 2;
    public static final int RANGE_MODE_DETERMINATE = 0;
    public static final int RANGE_MODE_INDETERMINATE = 1;

    @NonNull
    public ListBuilder addRating(@NonNull RatingBuilder b) {
        this.mImpl.addRating(b);
        return this;
    }

    public ListBuilder(@NonNull Context context, @NonNull Uri uri, long ttl) {
        super(context, uri);
        this.mImpl.setTtl(ttl);
    }

    @RequiresApi(value=26)
    public ListBuilder(@NonNull Context context, @NonNull Uri uri, @Nullable Duration ttl) {
        super(context, uri);
        this.mImpl.setTtl(ttl);
    }

    @Override
    @NonNull
    public Slice build() {
        return ((TemplateBuilderImpl)((Object)this.mImpl)).build();
    }

    @Override
    void setImpl(TemplateBuilderImpl impl) {
        this.mImpl = (androidx.slice.builders.impl.ListBuilder)((Object)impl);
    }

    @NonNull
    public ListBuilder addRow(@NonNull RowBuilder builder) {
        this.mImpl.addRow(builder);
        return this;
    }

    @NonNull
    public ListBuilder addGridRow(@NonNull GridRowBuilder builder) {
        this.mImpl.addGridRow(builder);
        return this;
    }

    @NonNull
    public ListBuilder setHeader(@NonNull HeaderBuilder builder) {
        this.mImpl.setHeader(builder);
        return this;
    }

    @NonNull
    public ListBuilder addAction(@NonNull SliceAction action) {
        this.mImpl.addAction(action);
        return this;
    }

    @NonNull
    public ListBuilder setAccentColor(@ColorInt int color) {
        this.mImpl.setColor(color);
        return this;
    }

    @NonNull
    public ListBuilder setKeywords(@NonNull Set<String> keywords) {
        this.mImpl.setKeywords(keywords);
        return this;
    }

    @NonNull
    public ListBuilder setLayoutDirection(int layoutDirection) {
        this.mImpl.setLayoutDirection(layoutDirection);
        return this;
    }

    @NonNull
    @RequiresApi(value=21)
    public ListBuilder setHostExtras(@NonNull PersistableBundle extras) {
        this.mImpl.setHostExtras(extras);
        return this;
    }

    @NonNull
    public ListBuilder setSeeMoreRow(@NonNull RowBuilder builder) {
        if (this.mHasSeeMore) {
            throw new IllegalArgumentException("Trying to add see more row when one has already been added");
        }
        this.mImpl.setSeeMoreRow(builder);
        this.mHasSeeMore = true;
        return this;
    }

    @NonNull
    public ListBuilder setSeeMoreAction(@NonNull PendingIntent intent) {
        if (this.mHasSeeMore) {
            throw new IllegalArgumentException("Trying to add see more action when one has already been added");
        }
        this.mImpl.setSeeMoreAction(intent);
        this.mHasSeeMore = true;
        return this;
    }

    @NonNull
    public ListBuilder setSeeMoreAction(@NonNull RemoteCallback callback) {
        if (this.mHasSeeMore) {
            throw new IllegalArgumentException("Trying to add see more action when one has already been added");
        }
        this.mImpl.setSeeMoreAction(callback.toPendingIntent());
        this.mHasSeeMore = true;
        return this;
    }

    @NonNull
    public ListBuilder setIsError(boolean isError) {
        this.mImpl.setIsError(isError);
        return this;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @Nullable
    protected TemplateBuilderImpl selectImpl() {
        if (this.checkCompatible(SliceSpecs.LIST_V2)) {
            return new ListBuilderImpl(this.getBuilder(), SliceSpecs.LIST_V2, this.getClock());
        }
        if (this.checkCompatible(SliceSpecs.LIST)) {
            return new ListBuilderImpl(this.getBuilder(), SliceSpecs.LIST, this.getClock());
        }
        if (this.checkCompatible(SliceSpecs.BASIC)) {
            return new ListBuilderBasicImpl(this.getBuilder(), SliceSpecs.BASIC);
        }
        return null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public androidx.slice.builders.impl.ListBuilder getImpl() {
        return this.mImpl;
    }

    @NonNull
    public ListBuilder addInputRange(@NonNull InputRangeBuilder b) {
        this.mImpl.addInputRange(b);
        return this;
    }

    @NonNull
    public ListBuilder addRange(@NonNull RangeBuilder rangeBuilder) {
        this.mImpl.addRange(rangeBuilder);
        return this;
    }

    @NonNull
    public ListBuilder addSelection(@NonNull SelectionBuilder selectionBuilder) {
        this.mImpl.addSelection(selectionBuilder);
        return this;
    }

    public static class HeaderBuilder {
        private final Uri mUri;
        private CharSequence mTitle;
        private boolean mTitleLoading;
        private CharSequence mSubtitle;
        private boolean mSubtitleLoading;
        private CharSequence mSummary;
        private boolean mSummaryLoading;
        private SliceAction mPrimaryAction;
        private CharSequence mContentDescription;
        private int mLayoutDirection;

        public HeaderBuilder() {
            this.mUri = null;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
        public HeaderBuilder(@NonNull Uri uri) {
            this.mUri = uri;
        }

        @NonNull
        public HeaderBuilder setTitle(@NonNull CharSequence title) {
            return this.setTitle(title, false);
        }

        @NonNull
        public HeaderBuilder setTitle(@NonNull CharSequence title, boolean isLoading) {
            this.mTitle = title;
            this.mTitleLoading = isLoading;
            return this;
        }

        @NonNull
        public HeaderBuilder setSubtitle(@NonNull CharSequence subtitle) {
            return this.setSubtitle(subtitle, false);
        }

        @NonNull
        public HeaderBuilder setSubtitle(@NonNull CharSequence subtitle, boolean isLoading) {
            this.mSubtitle = subtitle;
            this.mSubtitleLoading = isLoading;
            return this;
        }

        @NonNull
        public HeaderBuilder setSummary(@NonNull CharSequence summary) {
            return this.setSummary(summary, false);
        }

        @NonNull
        public HeaderBuilder setSummary(@NonNull CharSequence summary, boolean isLoading) {
            this.mSummary = summary;
            this.mSummaryLoading = isLoading;
            return this;
        }

        @NonNull
        public HeaderBuilder setPrimaryAction(@NonNull SliceAction action) {
            this.mPrimaryAction = action;
            return this;
        }

        @NonNull
        public HeaderBuilder setContentDescription(@NonNull CharSequence description) {
            this.mContentDescription = description;
            return this;
        }

        @NonNull
        public HeaderBuilder setLayoutDirection(int layoutDirection) {
            this.mLayoutDirection = layoutDirection;
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public Uri getUri() {
            return this.mUri;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public CharSequence getTitle() {
            return this.mTitle;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public boolean isTitleLoading() {
            return this.mTitleLoading;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public CharSequence getSubtitle() {
            return this.mSubtitle;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public boolean isSubtitleLoading() {
            return this.mSubtitleLoading;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public CharSequence getSummary() {
            return this.mSummary;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public boolean isSummaryLoading() {
            return this.mSummaryLoading;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public SliceAction getPrimaryAction() {
            return this.mPrimaryAction;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public CharSequence getContentDescription() {
            return this.mContentDescription;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public int getLayoutDirection() {
            return this.mLayoutDirection;
        }
    }

    public static class RowBuilder {
        private final Uri mUri;
        private boolean mIsEndOfSection;
        private boolean mHasEndActionOrToggle;
        private boolean mHasEndImage;
        private boolean mHasDefaultToggle;
        private boolean mHasTimestamp;
        private long mTimeStamp = -1L;
        private boolean mTitleItemLoading;
        private int mTitleImageMode;
        private IconCompat mTitleIcon;
        private SliceAction mTitleAction;
        private SliceAction mPrimaryAction;
        private CharSequence mTitle;
        private boolean mTitleLoading;
        private CharSequence mSubtitle;
        private boolean mSubtitleLoading;
        private CharSequence mContentDescription;
        private int mLayoutDirection = -1;
        private final List<Object> mEndItems = new ArrayList<Object>();
        private final List<Integer> mEndTypes = new ArrayList<Integer>();
        private final List<Boolean> mEndLoads = new ArrayList<Boolean>();
        private boolean mTitleActionLoading;
        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public static final int TYPE_TIMESTAMP = 0;
        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public static final int TYPE_ICON = 1;
        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public static final int TYPE_ACTION = 2;

        public RowBuilder() {
            this.mUri = null;
        }

        public RowBuilder(@NonNull Uri uri) {
            this.mUri = uri;
        }

        @NonNull
        public RowBuilder setEndOfSection(boolean isEndOfSection) {
            this.mIsEndOfSection = isEndOfSection;
            return this;
        }

        @NonNull
        public RowBuilder setTitleItem(long timeStamp) {
            if (this.mHasTimestamp) {
                throw new IllegalArgumentException("Trying to add a timestamp when one has already been added");
            }
            this.mTimeStamp = timeStamp;
            this.mHasTimestamp = true;
            return this;
        }

        @NonNull
        public RowBuilder setTitleItem(@NonNull IconCompat icon, int imageMode) {
            return this.setTitleItem(icon, imageMode, false);
        }

        @NonNull
        public RowBuilder setTitleItem(@Nullable IconCompat icon, int imageMode, boolean isLoading) {
            this.mTitleAction = null;
            this.mTitleIcon = icon;
            this.mTitleImageMode = imageMode;
            this.mTitleItemLoading = isLoading;
            return this;
        }

        @NonNull
        public RowBuilder setTitleItem(@NonNull SliceAction action) {
            return this.setTitleItem(action, false);
        }

        @NonNull
        public RowBuilder setTitleItem(@NonNull SliceAction action, boolean isLoading) {
            this.mTitleAction = action;
            this.mTitleIcon = null;
            this.mTitleImageMode = 0;
            this.mTitleActionLoading = isLoading;
            return this;
        }

        @NonNull
        public RowBuilder setPrimaryAction(@NonNull SliceAction action) {
            this.mPrimaryAction = action;
            return this;
        }

        @NonNull
        public RowBuilder setTitle(@NonNull CharSequence title) {
            return this.setTitle(title, false);
        }

        @NonNull
        public RowBuilder setTitle(@Nullable CharSequence title, boolean isLoading) {
            this.mTitle = title;
            this.mTitleLoading = isLoading;
            return this;
        }

        @NonNull
        public RowBuilder setSubtitle(@NonNull CharSequence subtitle) {
            return this.setSubtitle(subtitle, false);
        }

        @NonNull
        public RowBuilder setSubtitle(@Nullable CharSequence subtitle, boolean isLoading) {
            this.mSubtitle = subtitle;
            this.mSubtitleLoading = isLoading;
            return this;
        }

        @NonNull
        public RowBuilder addEndItem(long timeStamp) {
            if (this.mHasTimestamp) {
                throw new IllegalArgumentException("Trying to add a timestamp when one has already been added");
            }
            this.mEndItems.add(timeStamp);
            this.mEndTypes.add(0);
            this.mEndLoads.add(false);
            this.mHasTimestamp = true;
            return this;
        }

        @NonNull
        public RowBuilder addEndItem(@NonNull IconCompat icon, int imageMode) {
            return this.addEndItem(icon, imageMode, false);
        }

        @NonNull
        public RowBuilder addEndItem(@Nullable IconCompat icon, int imageMode, boolean isLoading) {
            if (this.mHasEndActionOrToggle) {
                throw new IllegalArgumentException("Trying to add an icon to end items when anaction has already been added. End items cannot have a mixture of actions and icons.");
            }
            this.mEndItems.add(new Pair((Object)icon, (Object)imageMode));
            this.mEndTypes.add(1);
            this.mEndLoads.add(isLoading);
            this.mHasEndImage = true;
            return this;
        }

        @NonNull
        public RowBuilder addEndItem(@NonNull SliceAction action) {
            return this.addEndItem(action, false);
        }

        @NonNull
        public RowBuilder addEndItem(@NonNull SliceAction action, boolean isLoading) {
            if (this.mHasEndImage) {
                throw new IllegalArgumentException("Trying to add an action to end items when anicon has already been added. End items cannot have a mixture of actions and icons.");
            }
            if (this.mHasDefaultToggle) {
                throw new IllegalStateException("Only one non-custom toggle can be added in a single row. If you would like to include multiple toggles in a row, set a custom icon for each toggle.");
            }
            this.mEndItems.add(action);
            this.mEndTypes.add(2);
            this.mEndLoads.add(isLoading);
            this.mHasDefaultToggle = action.getImpl().isDefaultToggle();
            this.mHasEndActionOrToggle = true;
            return this;
        }

        @NonNull
        public RowBuilder setContentDescription(@NonNull CharSequence description) {
            this.mContentDescription = description;
            return this;
        }

        @NonNull
        public RowBuilder setLayoutDirection(int layoutDirection) {
            this.mLayoutDirection = layoutDirection;
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public Uri getUri() {
            return this.mUri;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public boolean isEndOfSection() {
            return this.mIsEndOfSection;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public boolean hasEndActionOrToggle() {
            return this.mHasEndActionOrToggle;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public boolean hasEndImage() {
            return this.mHasEndImage;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public boolean hasDefaultToggle() {
            return this.mHasDefaultToggle;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public boolean hasTimestamp() {
            return this.mHasTimestamp;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public long getTimeStamp() {
            return this.mTimeStamp;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public boolean isTitleItemLoading() {
            return this.mTitleItemLoading;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public int getTitleImageMode() {
            return this.mTitleImageMode;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public IconCompat getTitleIcon() {
            return this.mTitleIcon;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public SliceAction getTitleAction() {
            return this.mTitleAction;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public SliceAction getPrimaryAction() {
            return this.mPrimaryAction;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public CharSequence getTitle() {
            return this.mTitle;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public boolean isTitleLoading() {
            return this.mTitleLoading;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public CharSequence getSubtitle() {
            return this.mSubtitle;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public boolean isSubtitleLoading() {
            return this.mSubtitleLoading;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public CharSequence getContentDescription() {
            return this.mContentDescription;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public int getLayoutDirection() {
            return this.mLayoutDirection;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @NonNull
        public List<Object> getEndItems() {
            return this.mEndItems;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @NonNull
        public List<Integer> getEndTypes() {
            return this.mEndTypes;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @NonNull
        public List<Boolean> getEndLoads() {
            return this.mEndLoads;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public boolean isTitleActionLoading() {
            return this.mTitleActionLoading;
        }
    }

    public static class InputRangeBuilder {
        private int mMin = 0;
        private int mMax = 100;
        private int mValue = 0;
        private boolean mValueSet = false;
        private CharSequence mTitle;
        private CharSequence mSubtitle;
        private PendingIntent mAction;
        private PendingIntent mInputAction;
        private IconCompat mThumb;
        private SliceAction mPrimaryAction;
        private CharSequence mContentDescription;
        private int mLayoutDirection = -1;
        private IconCompat mTitleIcon;
        private int mTitleImageMode;
        private boolean mTitleItemLoading;
        private boolean mHasDefaultToggle;
        private final List<Object> mEndItems = new ArrayList<Object>();
        private final List<Integer> mEndTypes = new ArrayList<Integer>();
        private final List<Boolean> mEndLoads = new ArrayList<Boolean>();
        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public static final int TYPE_ACTION = 2;

        @NonNull
        public InputRangeBuilder setTitleItem(@NonNull IconCompat icon, int imageMode) {
            return this.setTitleItem(icon, imageMode, false);
        }

        @NonNull
        public InputRangeBuilder addEndItem(@NonNull SliceAction action) {
            return this.addEndItem(action, false);
        }

        @NonNull
        public InputRangeBuilder addEndItem(@NonNull SliceAction action, boolean isLoading) {
            if (this.mHasDefaultToggle) {
                throw new IllegalStateException("Only one non-custom toggle can be added in a single row. If you would like to include multiple toggles in a row, set a custom icon for each toggle.");
            }
            this.mEndItems.add(action);
            this.mEndTypes.add(2);
            this.mEndLoads.add(isLoading);
            this.mHasDefaultToggle = action.getImpl().isDefaultToggle();
            return this;
        }

        @NonNull
        public InputRangeBuilder setTitleItem(@NonNull IconCompat icon, int imageMode, boolean isLoading) {
            this.mTitleIcon = icon;
            this.mTitleImageMode = imageMode;
            this.mTitleItemLoading = isLoading;
            return this;
        }

        @NonNull
        public InputRangeBuilder setMin(int min) {
            this.mMin = min;
            return this;
        }

        @NonNull
        public InputRangeBuilder setMax(int max) {
            this.mMax = max;
            return this;
        }

        @NonNull
        public InputRangeBuilder setValue(int value) {
            this.mValueSet = true;
            this.mValue = value;
            return this;
        }

        @NonNull
        public InputRangeBuilder setTitle(@NonNull CharSequence title) {
            this.mTitle = title;
            return this;
        }

        @NonNull
        public InputRangeBuilder setSubtitle(@NonNull CharSequence title) {
            this.mSubtitle = title;
            return this;
        }

        @NonNull
        public InputRangeBuilder setInputAction(@NonNull PendingIntent action) {
            this.mInputAction = action;
            return this;
        }

        @NonNull
        public InputRangeBuilder setInputAction(@NonNull RemoteCallback callback) {
            this.mInputAction = callback.toPendingIntent();
            return this;
        }

        @NonNull
        public InputRangeBuilder setThumb(@NonNull IconCompat thumb) {
            this.mThumb = thumb;
            return this;
        }

        @NonNull
        public InputRangeBuilder setPrimaryAction(@NonNull SliceAction action) {
            this.mPrimaryAction = action;
            return this;
        }

        @NonNull
        public InputRangeBuilder setContentDescription(@NonNull CharSequence description) {
            this.mContentDescription = description;
            return this;
        }

        @NonNull
        public InputRangeBuilder setLayoutDirection(int layoutDirection) {
            this.mLayoutDirection = layoutDirection;
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public boolean isTitleItemLoading() {
            return this.mTitleItemLoading;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public int getTitleImageMode() {
            return this.mTitleImageMode;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public IconCompat getTitleIcon() {
            return this.mTitleIcon;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @NonNull
        public List<Object> getEndItems() {
            return this.mEndItems;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @NonNull
        public List<Integer> getEndTypes() {
            return this.mEndTypes;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @NonNull
        public List<Boolean> getEndLoads() {
            return this.mEndLoads;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public int getMin() {
            return this.mMin;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public int getMax() {
            return this.mMax;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public int getValue() {
            return this.mValue;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public boolean isValueSet() {
            return this.mValueSet;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public CharSequence getTitle() {
            return this.mTitle;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public CharSequence getSubtitle() {
            return this.mSubtitle;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public PendingIntent getAction() {
            return this.mAction;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public PendingIntent getInputAction() {
            return this.mInputAction;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public IconCompat getThumb() {
            return this.mThumb;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public SliceAction getPrimaryAction() {
            return this.mPrimaryAction;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public CharSequence getContentDescription() {
            return this.mContentDescription;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public int getLayoutDirection() {
            return this.mLayoutDirection;
        }
    }

    @SuppressLint(value={"MissingBuildMethod"})
    public static final class RatingBuilder {
        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public static final int TYPE_ACTION = 2;
        private int mMin = 0;
        private int mMax = 5;
        private int mValue = 0;
        private boolean mValueSet = false;
        private CharSequence mContentDescription;
        private PendingIntent mAction;
        private PendingIntent mInputAction;
        private CharSequence mTitle;
        private CharSequence mSubtitle;
        private SliceAction mPrimaryAction;
        private IconCompat mTitleIcon;
        private int mTitleImageMode;
        private boolean mTitleItemLoading;

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public int getMin() {
            return this.mMin;
        }

        @NonNull
        public RatingBuilder setMin(int min) {
            this.mMin = min;
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public int getMax() {
            return this.mMax;
        }

        @NonNull
        public RatingBuilder setMax(int max) {
            this.mMax = max;
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public float getValue() {
            return this.mValue;
        }

        @NonNull
        public RatingBuilder setValue(float value) {
            this.mValueSet = true;
            this.mValue = Math.round(value);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public boolean isValueSet() {
            return this.mValueSet;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public PendingIntent getAction() {
            return this.mAction;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public CharSequence getContentDescription() {
            return this.mContentDescription;
        }

        @NonNull
        public RatingBuilder setTitle(@NonNull CharSequence title) {
            this.mTitle = title;
            return this;
        }

        @NonNull
        public RatingBuilder setSubtitle(@NonNull CharSequence title) {
            this.mSubtitle = title;
            return this;
        }

        @NonNull
        public RatingBuilder setPrimaryAction(@NonNull SliceAction action) {
            this.mPrimaryAction = action;
            return this;
        }

        @NonNull
        public RatingBuilder setTitleItem(@NonNull IconCompat icon, int imageMode) {
            return this.setTitleItem(icon, imageMode, false);
        }

        @NonNull
        public RatingBuilder setTitleItem(@NonNull IconCompat icon, int imageMode, boolean isLoading) {
            this.mTitleIcon = icon;
            this.mTitleImageMode = imageMode;
            this.mTitleItemLoading = isLoading;
            return this;
        }

        @NonNull
        public RatingBuilder setContentDescription(@NonNull CharSequence description) {
            this.mContentDescription = description;
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public PendingIntent getInputAction() {
            return this.mInputAction;
        }

        @SuppressLint(value={"ExecutorRegistration"})
        @NonNull
        public RatingBuilder setInputAction(@NonNull PendingIntent action) {
            this.mInputAction = action;
            return this;
        }

        @SuppressLint(value={"ExecutorRegistration"})
        @NonNull
        public RatingBuilder setInputAction(@NonNull RemoteCallback callback) {
            this.mInputAction = callback.toPendingIntent();
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public CharSequence getTitle() {
            return this.mTitle;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public CharSequence getSubtitle() {
            return this.mSubtitle;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public SliceAction getPrimaryAction() {
            return this.mPrimaryAction;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public boolean isTitleItemLoading() {
            return this.mTitleItemLoading;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public int getTitleImageMode() {
            return this.mTitleImageMode;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public IconCompat getTitleIcon() {
            return this.mTitleIcon;
        }
    }

    public static class RangeBuilder {
        private int mValue;
        private int mMax = 100;
        private boolean mValueSet = false;
        private CharSequence mTitle;
        private CharSequence mSubtitle;
        private SliceAction mPrimaryAction;
        private CharSequence mContentDescription;
        private int mLayoutDirection = -1;
        private int mMode = 0;
        private IconCompat mTitleIcon;
        private int mTitleImageMode;
        private boolean mTitleItemLoading;

        @NonNull
        public RangeBuilder setTitleItem(@NonNull IconCompat icon, int imageMode) {
            return this.setTitleItem(icon, imageMode, false);
        }

        @NonNull
        public RangeBuilder setTitleItem(@NonNull IconCompat icon, int imageMode, boolean isLoading) {
            this.mTitleIcon = icon;
            this.mTitleImageMode = imageMode;
            this.mTitleItemLoading = isLoading;
            return this;
        }

        @NonNull
        public RangeBuilder setMax(int max) {
            this.mMax = max;
            return this;
        }

        @NonNull
        public RangeBuilder setValue(int value) {
            this.mValueSet = true;
            this.mValue = value;
            return this;
        }

        @NonNull
        public RangeBuilder setTitle(@NonNull CharSequence title) {
            this.mTitle = title;
            return this;
        }

        @NonNull
        public RangeBuilder setSubtitle(@NonNull CharSequence title) {
            this.mSubtitle = title;
            return this;
        }

        @NonNull
        public RangeBuilder setPrimaryAction(@NonNull SliceAction action) {
            this.mPrimaryAction = action;
            return this;
        }

        @NonNull
        public RangeBuilder setContentDescription(@NonNull CharSequence description) {
            this.mContentDescription = description;
            return this;
        }

        @NonNull
        public RangeBuilder setLayoutDirection(int layoutDirection) {
            this.mLayoutDirection = layoutDirection;
            return this;
        }

        @NonNull
        public RangeBuilder setMode(int mode) {
            this.mMode = mode;
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public boolean isTitleItemLoading() {
            return this.mTitleItemLoading;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public int getTitleImageMode() {
            return this.mTitleImageMode;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public IconCompat getTitleIcon() {
            return this.mTitleIcon;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public int getValue() {
            return this.mValue;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public int getMax() {
            return this.mMax;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public boolean isValueSet() {
            return this.mValueSet;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public CharSequence getTitle() {
            return this.mTitle;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public CharSequence getSubtitle() {
            return this.mSubtitle;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public SliceAction getPrimaryAction() {
            return this.mPrimaryAction;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public CharSequence getContentDescription() {
            return this.mContentDescription;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public int getLayoutDirection() {
            return this.mLayoutDirection;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public int getMode() {
            return this.mMode;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface RangeMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface LayoutDirection {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface ImageMode {
    }
}

