/*
 * Decompiled with CFR 0.152.
 */
package androidx.slice.builders;

import android.content.Context;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.graphics.drawable.IconCompat;
import androidx.core.util.Consumer;
import androidx.slice.SliceSpecs;
import androidx.slice.builders.TemplateSliceBuilder;
import androidx.slice.builders.impl.MessagingBasicImpl;
import androidx.slice.builders.impl.MessagingBuilder;
import androidx.slice.builders.impl.MessagingListV1Impl;
import androidx.slice.builders.impl.MessagingV1Impl;
import androidx.slice.builders.impl.TemplateBuilderImpl;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
@RequiresApi(value=19)
public class MessagingSliceBuilder
extends TemplateSliceBuilder {
    public static final int MAXIMUM_RETAINED_MESSAGES = 50;
    MessagingBuilder mBuilder;

    public MessagingSliceBuilder(@NonNull Context context, @NonNull Uri uri) {
        super(context, uri);
    }

    public MessagingSliceBuilder add(MessageBuilder builder) {
        this.mBuilder.add((TemplateBuilderImpl)((Object)builder.mImpl));
        return this;
    }

    public MessagingSliceBuilder add(Consumer<MessageBuilder> c) {
        MessageBuilder b = new MessageBuilder(this);
        c.accept((Object)b);
        return this.add(b);
    }

    @Override
    void setImpl(TemplateBuilderImpl impl) {
        this.mBuilder = (MessagingBuilder)((Object)impl);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    protected TemplateBuilderImpl selectImpl() {
        if (this.checkCompatible(SliceSpecs.MESSAGING)) {
            return new MessagingV1Impl(this.getBuilder(), SliceSpecs.MESSAGING);
        }
        if (this.checkCompatible(SliceSpecs.LIST)) {
            return new MessagingListV1Impl(this.getBuilder(), SliceSpecs.LIST);
        }
        if (this.checkCompatible(SliceSpecs.BASIC)) {
            return new MessagingBasicImpl(this.getBuilder(), SliceSpecs.BASIC);
        }
        return null;
    }

    public static final class MessageBuilder
    extends TemplateSliceBuilder {
        MessagingBuilder.MessageBuilder mImpl;

        public MessageBuilder(MessagingSliceBuilder parent) {
            super(parent.mBuilder.createMessageBuilder());
        }

        @RequiresApi(value=23)
        public MessageBuilder addSource(Icon source) {
            this.mImpl.addSource(source);
            return this;
        }

        public MessageBuilder addSource(IconCompat source) {
            if (Build.VERSION.SDK_INT >= 23) {
                this.mImpl.addSource(source.toIcon());
            }
            return this;
        }

        public MessageBuilder addText(CharSequence text) {
            this.mImpl.addText(text);
            return this;
        }

        public MessageBuilder addTimestamp(long timestamp) {
            this.mImpl.addTimestamp(timestamp);
            return this;
        }

        @Override
        void setImpl(TemplateBuilderImpl impl) {
            this.mImpl = (MessagingBuilder.MessageBuilder)((Object)impl);
        }
    }
}

