/*
 * Decompiled with CFR 0.152.
 */
package androidx.slice.builders;

import android.app.PendingIntent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.collection.ArraySet;
import androidx.core.util.Pair;
import androidx.remotecallback.RemoteCallback;
import androidx.slice.builders.SliceAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@RequiresApi(value=19)
public class SelectionBuilder {
    private final List<Pair<String, CharSequence>> mOptions = new ArrayList<Pair<String, CharSequence>>();
    private final Set<String> mOptionKeys = new ArraySet();
    private String mSelectedOption = null;
    private SliceAction mPrimaryAction;
    private PendingIntent mInputAction;
    private CharSequence mTitle;
    private CharSequence mSubtitle;
    private CharSequence mContentDescription;
    private int mLayoutDirection = -1;

    public SelectionBuilder addOption(String optionKey, CharSequence optionText) {
        if (this.mOptionKeys.contains(optionKey)) {
            throw new IllegalArgumentException("optionKey " + optionKey + " is a duplicate");
        }
        this.mOptions.add((Pair<String, CharSequence>)new Pair((Object)optionKey, (Object)optionText));
        this.mOptionKeys.add(optionKey);
        return this;
    }

    public SelectionBuilder setPrimaryAction(@NonNull SliceAction primaryAction) {
        this.mPrimaryAction = primaryAction;
        return this;
    }

    public SelectionBuilder setInputAction(@NonNull PendingIntent inputAction) {
        this.mInputAction = inputAction;
        return this;
    }

    public SelectionBuilder setInputAction(@NonNull RemoteCallback inputAction) {
        this.mInputAction = inputAction.toPendingIntent();
        return this;
    }

    public SelectionBuilder setSelectedOption(String selectedOption) {
        this.mSelectedOption = selectedOption;
        return this;
    }

    public SelectionBuilder setTitle(@Nullable CharSequence title) {
        this.mTitle = title;
        return this;
    }

    public SelectionBuilder setSubtitle(@Nullable CharSequence subtitle) {
        this.mSubtitle = subtitle;
        return this;
    }

    public SelectionBuilder setContentDescription(@Nullable CharSequence contentDescription) {
        this.mContentDescription = contentDescription;
        return this;
    }

    public SelectionBuilder setLayoutDirection(int layoutDirection) {
        this.mLayoutDirection = layoutDirection;
        return this;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public List<Pair<String, CharSequence>> getOptions() {
        return this.mOptions;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public SliceAction getPrimaryAction() {
        return this.mPrimaryAction;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public PendingIntent getInputAction() {
        return this.mInputAction;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public String getSelectedOption() {
        return this.mSelectedOption;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public CharSequence getTitle() {
        return this.mTitle;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public CharSequence getSubtitle() {
        return this.mSubtitle;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public CharSequence getContentDescription() {
        return this.mContentDescription;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public int getLayoutDirection() {
        return this.mLayoutDirection;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void check() {
        if (this.getPrimaryAction() == null) {
            throw new IllegalArgumentException("primaryAction must be set");
        }
        if (this.getInputAction() == null) {
            throw new IllegalArgumentException("inputAction must be set");
        }
        if (this.mSelectedOption != null && !this.mOptionKeys.contains(this.mSelectedOption)) {
            throw new IllegalArgumentException("selectedOption must be present in options");
        }
    }
}

