/*
 * Decompiled with CFR 0.152.
 */
package androidx.slice.builders;

import android.app.PendingIntent;
import android.graphics.drawable.Icon;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.graphics.drawable.IconCompat;
import androidx.remotecallback.RemoteCallback;
import androidx.slice.Slice;
import androidx.slice.core.SliceActionImpl;

@RequiresApi(value=19)
public class SliceAction
implements androidx.slice.core.SliceAction {
    private final SliceActionImpl mSliceAction;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @RequiresApi(value=23)
    public SliceAction(@NonNull PendingIntent action, @NonNull Icon actionIcon, @NonNull CharSequence actionTitle) {
        this(action, actionIcon, 0, actionTitle);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @RequiresApi(value=23)
    public SliceAction(@NonNull PendingIntent action, @NonNull Icon actionIcon, int imageMode, @NonNull CharSequence actionTitle) {
        this(action, IconCompat.createFromIcon((Icon)actionIcon), imageMode, actionTitle);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @RequiresApi(value=23)
    public SliceAction(@NonNull PendingIntent action, @NonNull Icon actionIcon, @NonNull CharSequence actionTitle, boolean isChecked) {
        this(action, IconCompat.createFromIcon((Icon)actionIcon), actionTitle, isChecked);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public SliceAction(@NonNull PendingIntent action, @NonNull IconCompat actionIcon, @NonNull CharSequence actionTitle) {
        this(action, actionIcon, 0, actionTitle);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public SliceAction(@NonNull PendingIntent action, @NonNull IconCompat actionIcon, int imageMode, @NonNull CharSequence actionTitle) {
        this.mSliceAction = new SliceActionImpl(action, actionIcon, imageMode, actionTitle);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public SliceAction(@NonNull PendingIntent action, @NonNull IconCompat actionIcon, @NonNull CharSequence actionTitle, boolean isChecked) {
        this.mSliceAction = new SliceActionImpl(action, actionIcon, actionTitle, isChecked);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public SliceAction(@NonNull PendingIntent action, @NonNull CharSequence actionTitle, boolean isChecked) {
        this.mSliceAction = new SliceActionImpl(action, actionTitle, isChecked);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public SliceAction(@NonNull PendingIntent action, @NonNull CharSequence actionTitle, long dateTimeMillis, boolean isDatePicker) {
        this.mSliceAction = new SliceActionImpl(action, actionTitle, dateTimeMillis, isDatePicker);
    }

    public static SliceAction create(@NonNull PendingIntent action, @NonNull IconCompat actionIcon, int imageMode, @NonNull CharSequence actionTitle) {
        return new SliceAction(action, actionIcon, imageMode, actionTitle);
    }

    public static SliceAction create(@NonNull RemoteCallback action, @NonNull IconCompat actionIcon, int imageMode, @NonNull CharSequence actionTitle) {
        return new SliceAction(action.toPendingIntent(), actionIcon, imageMode, actionTitle);
    }

    @NonNull
    public static SliceAction createDatePicker(@NonNull PendingIntent action, @NonNull CharSequence actionTitle, long dateTimeMillis) {
        return new SliceAction(action, actionTitle, dateTimeMillis, true);
    }

    @NonNull
    public static SliceAction createTimePicker(@NonNull PendingIntent action, @NonNull CharSequence actionTitle, long dateTimeMillis) {
        return new SliceAction(action, actionTitle, dateTimeMillis, false);
    }

    public static SliceAction createDeeplink(@NonNull PendingIntent action, @NonNull IconCompat actionIcon, int imageMode, @NonNull CharSequence actionTitle) {
        SliceAction sliceAction = new SliceAction(action, actionIcon, imageMode, actionTitle);
        sliceAction.mSliceAction.setActivity(true);
        return sliceAction;
    }

    public static SliceAction createDeeplink(@NonNull RemoteCallback action, @NonNull IconCompat actionIcon, int imageMode, @NonNull CharSequence actionTitle) {
        SliceAction sliceAction = new SliceAction(action.toPendingIntent(), actionIcon, imageMode, actionTitle);
        sliceAction.mSliceAction.setActivity(true);
        return sliceAction;
    }

    public static SliceAction createToggle(@NonNull PendingIntent action, @NonNull CharSequence actionTitle, boolean isChecked) {
        return new SliceAction(action, actionTitle, isChecked);
    }

    public static SliceAction createToggle(@NonNull RemoteCallback action, @NonNull CharSequence actionTitle, boolean isChecked) {
        return new SliceAction(action.toPendingIntent(), actionTitle, isChecked);
    }

    public static SliceAction createToggle(@NonNull PendingIntent action, @NonNull IconCompat actionIcon, @NonNull CharSequence actionTitle, boolean isChecked) {
        return new SliceAction(action, actionIcon, actionTitle, isChecked);
    }

    public static SliceAction createToggle(@NonNull RemoteCallback action, @NonNull IconCompat actionIcon, @NonNull CharSequence actionTitle, boolean isChecked) {
        return new SliceAction(action.toPendingIntent(), actionIcon, actionTitle, isChecked);
    }

    @NonNull
    public androidx.slice.core.SliceAction setContentDescription(@NonNull CharSequence description) {
        this.mSliceAction.setContentDescription(description);
        return this;
    }

    @NonNull
    public SliceAction setChecked(boolean isChecked) {
        this.mSliceAction.setChecked(isChecked);
        return this;
    }

    @NonNull
    public SliceAction setPriority(@IntRange(from=0L) int priority) {
        this.mSliceAction.setPriority(priority);
        return this;
    }

    @NonNull
    public SliceAction setKey(@NonNull String key) {
        this.mSliceAction.setKey(key);
        return this;
    }

    @NonNull
    public PendingIntent getAction() {
        return this.mSliceAction.getAction();
    }

    @Nullable
    public IconCompat getIcon() {
        return this.mSliceAction.getIcon();
    }

    @NonNull
    public CharSequence getTitle() {
        return this.mSliceAction.getTitle();
    }

    public boolean isActivity() {
        return this.mSliceAction.isActivity();
    }

    @Nullable
    public CharSequence getContentDescription() {
        return this.mSliceAction.getContentDescription();
    }

    public int getPriority() {
        return this.mSliceAction.getPriority();
    }

    @Nullable
    public String getKey() {
        return this.mSliceAction.getKey();
    }

    public boolean isToggle() {
        return this.mSliceAction.isToggle();
    }

    public boolean isChecked() {
        return this.mSliceAction.isChecked();
    }

    public int getImageMode() {
        return this.mSliceAction.getImageMode();
    }

    public boolean isDefaultToggle() {
        return this.mSliceAction.isDefaultToggle();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public Slice buildSlice(@NonNull Slice.Builder builder) {
        return this.mSliceAction.buildSlice(builder);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public SliceActionImpl getImpl() {
        return this.mSliceAction;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setPrimaryAction(@NonNull Slice.Builder builder) {
        builder.addAction(this.mSliceAction.getAction(), this.mSliceAction.buildPrimaryActionSlice(builder), this.mSliceAction.getSubtype());
    }
}

