/*
 * Decompiled with CFR 0.152.
 */
package androidx.slice.builders;

import android.content.Context;
import android.net.Uri;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.slice.Clock;
import androidx.slice.Slice;
import androidx.slice.SliceManager;
import androidx.slice.SliceProvider;
import androidx.slice.SliceSpec;
import androidx.slice.SystemClock;
import androidx.slice.builders.impl.TemplateBuilderImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@RequiresApi(value=19)
public abstract class TemplateSliceBuilder {
    private static final String TAG = "TemplateSliceBuilder";
    private final Slice.Builder mBuilder;
    private final Context mContext;
    private final TemplateBuilderImpl mImpl;
    private List<SliceSpec> mSpecs;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    protected TemplateSliceBuilder(TemplateBuilderImpl impl) {
        this.mContext = null;
        this.mBuilder = null;
        this.mImpl = impl;
        this.setImpl(impl);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public TemplateSliceBuilder(Context context, Uri uri) {
        this.mBuilder = new Slice.Builder(uri);
        this.mContext = context;
        this.mSpecs = this.getSpecs(uri);
        this.mImpl = this.selectImpl();
        if (this.mImpl == null) {
            throw new IllegalArgumentException("No valid specs found");
        }
        this.setImpl(this.mImpl);
    }

    @NonNull
    public Slice build() {
        return this.mImpl.build();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    protected Slice.Builder getBuilder() {
        return this.mBuilder;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    abstract void setImpl(TemplateBuilderImpl var1);

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    protected TemplateBuilderImpl selectImpl() {
        return null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    protected boolean checkCompatible(SliceSpec candidate) {
        int size = this.mSpecs.size();
        for (int i = 0; i < size; ++i) {
            if (!this.mSpecs.get(i).canRender(candidate)) continue;
            return true;
        }
        return false;
    }

    private List<SliceSpec> getSpecs(Uri uri) {
        if (SliceProvider.getCurrentSpecs() != null) {
            return new ArrayList<SliceSpec>(SliceProvider.getCurrentSpecs());
        }
        Set pinnedSpecs = SliceManager.getInstance((Context)this.mContext).getPinnedSpecs(uri);
        return new ArrayList<SliceSpec>(pinnedSpecs);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    protected Clock getClock() {
        if (SliceProvider.getClock() != null) {
            return SliceProvider.getClock();
        }
        return new SystemClock();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    static <T> Pair<SliceSpec, Class<? extends TemplateBuilderImpl>> pair(SliceSpec spec, Class<T> cls) {
        return new Pair((Object)spec, cls);
    }
}

