/*
 * Decompiled with CFR 0.152.
 */
package androidx.slice.builders.impl;

import android.app.PendingIntent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.graphics.drawable.IconCompat;
import androidx.core.util.Pair;
import androidx.slice.Slice;
import androidx.slice.builders.GridRowBuilder;
import androidx.slice.builders.SliceAction;
import androidx.slice.builders.impl.ListBuilderImpl;
import androidx.slice.builders.impl.TemplateBuilderImpl;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@RequiresApi(value=19)
public class GridRowBuilderListV1Impl
extends TemplateBuilderImpl {
    private SliceAction mPrimaryAction;

    public GridRowBuilderListV1Impl(@NonNull ListBuilderImpl parent, GridRowBuilder builder) {
        super(parent.createChildBuilder(), null);
        if (builder.getLayoutDirection() != -1) {
            this.setLayoutDirection(builder.getLayoutDirection());
        }
        if (builder.getDescription() != null) {
            this.setContentDescription(builder.getDescription());
        }
        if (builder.getSeeMoreIntent() != null) {
            this.setSeeMoreAction(builder.getSeeMoreIntent());
        } else if (builder.getSeeMoreCell() != null) {
            this.setSeeMoreCell(builder.getSeeMoreCell());
        }
        if (builder.getPrimaryAction() != null) {
            this.setPrimaryAction(builder.getPrimaryAction());
        }
        for (GridRowBuilder.CellBuilder b : builder.getCells()) {
            this.addCell(b);
        }
    }

    @Override
    public void apply(@NonNull Slice.Builder builder) {
        builder.addHints(new String[]{"horizontal"});
        if (this.mPrimaryAction != null) {
            this.mPrimaryAction.setPrimaryAction(builder);
        }
    }

    public void addCell(GridRowBuilder.CellBuilder builder) {
        CellBuilderImpl impl = new CellBuilderImpl(this);
        impl.fillFrom(builder);
        impl.apply(this.getBuilder());
    }

    public void setSeeMoreCell(@NonNull GridRowBuilder.CellBuilder builder) {
        CellBuilderImpl impl = new CellBuilderImpl(this);
        impl.fillFrom(builder);
        impl.getBuilder().addHints(new String[]{"see_more"});
        impl.apply(this.getBuilder());
    }

    public void setSeeMoreAction(PendingIntent intent) {
        this.getBuilder().addSubSlice(new Slice.Builder(this.getBuilder()).addHints(new String[]{"see_more"}).addAction(intent, new Slice.Builder(this.getBuilder()).build(), null).build());
    }

    public void setPrimaryAction(SliceAction action) {
        this.mPrimaryAction = action;
    }

    public void setContentDescription(CharSequence description) {
        this.getBuilder().addText(description, "content_description", new String[0]);
    }

    public void setLayoutDirection(int layoutDirection) {
        this.getBuilder().addInt(layoutDirection, "layout_direction", new String[0]);
    }

    public static final class CellBuilderImpl
    extends TemplateBuilderImpl {
        private PendingIntent mContentIntent;

        CellBuilderImpl(@NonNull GridRowBuilderListV1Impl parent) {
            super(parent.createChildBuilder(), null);
        }

        public void fillFrom(GridRowBuilder.CellBuilder builder) {
            if (builder.getCellDescription() != null) {
                this.setContentDescription(builder.getCellDescription());
            }
            if (builder.getContentIntent() != null) {
                this.setContentIntent(builder.getContentIntent());
            }
            if (builder.getSliceAction() != null) {
                this.setSliceAction(builder.getSliceAction());
            }
            List<Object> objs = builder.getObjects();
            List<Integer> types = builder.getTypes();
            List<Boolean> loadings = builder.getLoadings();
            block6: for (int i = 0; i < objs.size(); ++i) {
                switch (types.get(i)) {
                    case 0: {
                        this.addText((CharSequence)objs.get(i), loadings.get(i));
                        continue block6;
                    }
                    case 1: {
                        this.addTitleText((CharSequence)objs.get(i), loadings.get(i));
                        continue block6;
                    }
                    case 2: {
                        Pair pair = (Pair)objs.get(i);
                        this.addImage((IconCompat)pair.first, (Integer)pair.second, loadings.get(i));
                        continue block6;
                    }
                    case 3: {
                        this.addOverlayText((CharSequence)objs.get(i), loadings.get(i));
                    }
                }
            }
        }

        private void addText(@Nullable CharSequence text, boolean isLoading) {
            String[] stringArray;
            if (isLoading) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "partial";
            } else {
                stringArray = new String[]{};
            }
            String[] hints = stringArray;
            this.getBuilder().addText(text, null, hints);
        }

        private void addTitleText(@Nullable CharSequence text, boolean isLoading) {
            String[] stringArray;
            if (isLoading) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "partial";
                stringArray = stringArray2;
                stringArray2[1] = "title";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "title";
            }
            String[] hints = stringArray;
            this.getBuilder().addText(text, null, hints);
        }

        private void addImage(@Nullable IconCompat image, int imageMode, boolean isLoading) {
            this.getBuilder().addIcon(image, null, this.parseImageMode(imageMode, isLoading));
        }

        private void addOverlayText(@Nullable CharSequence text, boolean isLoading) {
            String[] stringArray;
            if (isLoading) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "partial";
                stringArray = stringArray2;
                stringArray2[1] = "overlay";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "overlay";
            }
            String[] hints = stringArray;
            this.getBuilder().addText(text, null, hints);
        }

        private void setContentIntent(@NonNull PendingIntent intent) {
            this.mContentIntent = intent;
        }

        private void setContentDescription(CharSequence description) {
            this.getBuilder().addText(description, "content_description", new String[0]);
        }

        public void setSliceAction(@NonNull SliceAction action) {
            action.setPrimaryAction(this.getBuilder());
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public void apply(@NonNull Slice.Builder b) {
            this.getBuilder().addHints(new String[]{"horizontal"});
            if (this.mContentIntent != null) {
                b.addAction(this.mContentIntent, this.getBuilder().build(), null);
            } else {
                b.addSubSlice(this.getBuilder().build());
            }
        }
    }
}

