/*
 * Decompiled with CFR 0.152.
 */
package androidx.slice.builders.impl;

import android.app.PendingIntent;
import android.os.Bundle;
import android.os.PersistableBundle;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.graphics.drawable.IconCompat;
import androidx.slice.Slice;
import androidx.slice.SliceItem;
import androidx.slice.SliceSpec;
import androidx.slice.builders.GridRowBuilder;
import androidx.slice.builders.ListBuilder;
import androidx.slice.builders.SelectionBuilder;
import androidx.slice.builders.SliceAction;
import androidx.slice.builders.impl.ListBuilder;
import androidx.slice.builders.impl.TemplateBuilderImpl;
import java.time.Duration;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@RequiresApi(value=19)
public class ListBuilderBasicImpl
extends TemplateBuilderImpl
implements ListBuilder {
    boolean mIsError;
    private Set<String> mKeywords;
    private CharSequence mTitle;
    private CharSequence mSubtitle;
    private SliceAction mSliceAction;
    private IconCompat mIconCompat;
    private Bundle mHostExtras;

    public ListBuilderBasicImpl(Slice.Builder b, SliceSpec spec) {
        super(b, spec);
    }

    @Override
    public void addRow(@NonNull ListBuilder.RowBuilder builder) {
        if (this.mTitle == null && builder.getTitle() != null) {
            this.mTitle = builder.getTitle();
        }
        if (this.mSubtitle == null && builder.getSubtitle() != null) {
            this.mSubtitle = builder.getSubtitle();
        }
        if (this.mSliceAction == null && builder.getPrimaryAction() != null) {
            this.mSliceAction = builder.getPrimaryAction();
        }
        if (this.mSliceAction == null && builder.getTitleAction() != null) {
            this.mSliceAction = builder.getTitleAction();
        }
        if (this.mIconCompat == null && builder.getTitleIcon() != null) {
            this.mIconCompat = builder.getTitleIcon();
        }
    }

    @Override
    public void addGridRow(@NonNull GridRowBuilder builder) {
        for (GridRowBuilder.CellBuilder cell : builder.getCells()) {
            if (this.mTitle == null) {
                if (cell.getTitle() != null) {
                    this.mTitle = cell.getTitle();
                } else if (cell.getSubtitle() != null) {
                    this.mTitle = cell.getSubtitle();
                } else if (cell.getCellDescription() != null) {
                    this.mTitle = cell.getCellDescription();
                }
            }
            if (this.mSubtitle == null && cell.getSubtitle() != null) {
                this.mSubtitle = cell.getSubtitle();
            }
            if (this.mTitle == null || this.mSubtitle == null) continue;
            break;
        }
        if (this.mSliceAction == null && builder.getPrimaryAction() != null) {
            this.mSliceAction = builder.getPrimaryAction();
            if (this.mTitle == null && this.mSliceAction.getTitle() != null) {
                this.mTitle = this.mSliceAction.getTitle();
            }
        }
    }

    @Override
    public void addAction(@NonNull SliceAction action) {
    }

    @Override
    public void setHeader(@NonNull ListBuilder.HeaderBuilder builder) {
        if (builder.getTitle() != null) {
            this.mTitle = builder.getTitle();
        }
        if (builder.getSubtitle() != null) {
            this.mSubtitle = builder.getSubtitle();
        }
        if (builder.getPrimaryAction() != null) {
            this.mSliceAction = builder.getPrimaryAction();
        }
    }

    @Override
    public void addRating(@NonNull ListBuilder.RatingBuilder builder) {
        if (this.mTitle == null && builder.getTitle() != null) {
            this.mTitle = builder.getTitle();
        }
        if (this.mSubtitle == null && builder.getSubtitle() != null) {
            this.mSubtitle = builder.getSubtitle();
        }
        if (this.mSliceAction == null && builder.getPrimaryAction() != null) {
            this.mSliceAction = builder.getPrimaryAction();
        }
    }

    @Override
    public void addInputRange(@NonNull ListBuilder.InputRangeBuilder builder) {
        if (this.mTitle == null && builder.getTitle() != null) {
            this.mTitle = builder.getTitle();
        }
        if (this.mSubtitle == null && builder.getSubtitle() != null) {
            this.mSubtitle = builder.getSubtitle();
        }
        if (this.mSliceAction == null && builder.getPrimaryAction() != null) {
            this.mSliceAction = builder.getPrimaryAction();
        }
        if (this.mIconCompat == null && builder.getThumb() != null) {
            this.mIconCompat = builder.getThumb();
        }
    }

    @Override
    public void addRange(@NonNull ListBuilder.RangeBuilder builder) {
        if (this.mTitle == null && builder.getTitle() != null) {
            this.mTitle = builder.getTitle();
        }
        if (this.mSubtitle == null && builder.getSubtitle() != null) {
            this.mSubtitle = builder.getSubtitle();
        }
        if (this.mSliceAction == null && builder.getPrimaryAction() != null) {
            this.mSliceAction = builder.getPrimaryAction();
        }
    }

    @Override
    public void addSelection(@NonNull SelectionBuilder builder) {
        if (this.mTitle == null && builder.getTitle() != null) {
            this.mTitle = builder.getTitle();
        }
        if (this.mSubtitle == null && builder.getSubtitle() != null) {
            this.mSubtitle = builder.getSubtitle();
        }
        if (this.mSliceAction == null && builder.getPrimaryAction() != null) {
            this.mSliceAction = builder.getPrimaryAction();
        }
    }

    @Override
    public void setSeeMoreRow(@NonNull ListBuilder.RowBuilder builder) {
    }

    @Override
    public void setSeeMoreAction(@NonNull PendingIntent intent) {
    }

    @Override
    public void setColor(@ColorInt int color) {
        this.getBuilder().addInt(color, "color", new String[0]);
    }

    @Override
    public void setKeywords(@NonNull Set<String> keywords) {
        this.mKeywords = keywords;
    }

    @Override
    public void setTtl(long ttl) {
        long expiry = ttl == -1L ? -1L : this.getClock().currentTimeMillis() + ttl;
        this.getBuilder().addTimestamp(expiry, "millis", new String[]{"ttl"});
    }

    @Override
    @RequiresApi(value=26)
    public void setTtl(@Nullable Duration ttl) {
        this.setTtl(ttl == null ? -1L : ttl.toMillis());
    }

    @Override
    public void setIsError(boolean isError) {
        this.mIsError = isError;
    }

    @Override
    public void setLayoutDirection(int layoutDirection) {
        this.getBuilder().addInt(layoutDirection, "layout_direction", new String[0]);
    }

    @Override
    @RequiresApi(value=21)
    public void setHostExtras(@NonNull PersistableBundle extras) {
        this.mHostExtras = ConvertPersistableBundleApi21Impl.toBundle(extras);
    }

    @Override
    public void apply(@NonNull Slice.Builder builder) {
        if (this.mIsError) {
            builder.addHints(new String[]{"error"});
        }
        if (this.mKeywords != null) {
            Slice.Builder sb = new Slice.Builder(this.getBuilder());
            for (String keyword : this.mKeywords) {
                sb.addText((CharSequence)keyword, null, new String[0]);
            }
            builder.addSubSlice(sb.addHints(new String[]{"keywords"}).build());
        }
        Slice.Builder slice = new Slice.Builder(this.getBuilder());
        if (this.mSliceAction != null) {
            if (this.mTitle == null && this.mSliceAction.getTitle() != null) {
                this.mTitle = this.mSliceAction.getTitle();
            }
            if (this.mIconCompat == null && this.mSliceAction.getIcon() != null) {
                this.mIconCompat = this.mSliceAction.getIcon();
            }
            this.mSliceAction.setPrimaryAction(slice);
        }
        if (this.mTitle != null) {
            slice.addItem(new SliceItem((Object)this.mTitle, "text", null, new String[]{"title"}));
        }
        if (this.mSubtitle != null) {
            slice.addItem(new SliceItem((Object)this.mSubtitle, "text", null, new String[0]));
        }
        if (this.mIconCompat != null) {
            builder.addIcon(this.mIconCompat, null, new String[]{"title"});
        }
        if (this.mHostExtras != null) {
            slice.addItem(new SliceItem((Object)this.mHostExtras, "bundle", "host_extras", new String[0]));
        }
        builder.addSubSlice(slice.build());
    }

    @RequiresApi(value=21)
    private static class ConvertPersistableBundleApi21Impl {
        private ConvertPersistableBundleApi21Impl() {
        }

        static Bundle toBundle(@NonNull PersistableBundle extras) {
            return new Bundle(extras);
        }
    }
}

