/*
 * Decompiled with CFR 0.152.
 */
package androidx.slice.builders.impl;

import android.app.PendingIntent;
import android.os.Bundle;
import android.os.PersistableBundle;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.graphics.drawable.IconCompat;
import androidx.core.util.Pair;
import androidx.slice.Clock;
import androidx.slice.Slice;
import androidx.slice.SliceItem;
import androidx.slice.SliceSpec;
import androidx.slice.SliceSpecs;
import androidx.slice.SystemClock;
import androidx.slice.builders.GridRowBuilder;
import androidx.slice.builders.ListBuilder;
import androidx.slice.builders.SelectionBuilder;
import androidx.slice.builders.SliceAction;
import androidx.slice.builders.impl.GridRowBuilderListV1Impl;
import androidx.slice.builders.impl.ListBuilder;
import androidx.slice.builders.impl.SelectionBuilderBasicImpl;
import androidx.slice.builders.impl.SelectionBuilderListV2Impl;
import androidx.slice.builders.impl.TemplateBuilderImpl;
import androidx.slice.core.SliceQuery;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@RequiresApi(value=19)
public class ListBuilderImpl
extends TemplateBuilderImpl
implements ListBuilder {
    private List<Slice> mSliceActions;
    private Set<String> mKeywords;
    private Slice mSliceHeader;
    private boolean mIsError;
    private boolean mFirstRowChecked;
    private boolean mIsFirstRowTypeValid;
    private boolean mFirstRowHasText;
    private Bundle mHostExtras;

    public ListBuilderImpl(@Nullable Slice.Builder b, @Nullable SliceSpec spec) {
        this(b, spec, (Clock)new SystemClock());
    }

    public ListBuilderImpl(@Nullable Slice.Builder b, @Nullable SliceSpec spec, @NonNull Clock clock) {
        super(b, spec, clock);
    }

    @Override
    public void apply(@NonNull Slice.Builder builder) {
        Slice.Builder sb;
        builder.addLong(this.getClock().currentTimeMillis(), "millis", new String[]{"last_updated"});
        if (this.mSliceHeader != null) {
            builder.addSubSlice(this.mSliceHeader);
        }
        if (this.mSliceActions != null) {
            sb = new Slice.Builder(builder);
            for (int i = 0; i < this.mSliceActions.size(); ++i) {
                sb.addSubSlice(this.mSliceActions.get(i));
            }
            builder.addSubSlice(sb.addHints(new String[]{"actions"}).build());
        }
        if (this.mIsError) {
            builder.addHints(new String[]{"error"});
        }
        if (this.mKeywords != null) {
            sb = new Slice.Builder(this.getBuilder());
            for (String keyword : this.mKeywords) {
                sb.addText((CharSequence)keyword, null, new String[0]);
            }
            this.getBuilder().addSubSlice(sb.addHints(new String[]{"keywords"}).build());
        }
        if (this.mHostExtras != null) {
            builder.addItem(new SliceItem((Object)this.mHostExtras, "bundle", "host_extras", new String[0]));
        }
    }

    @Override
    @NonNull
    public Slice build() {
        Slice slice = super.build();
        boolean isLoading = SliceQuery.find((Slice)slice, null, (String)"partial", null) != null;
        boolean isEmpty = SliceQuery.find((Slice)slice, (String)"slice", (String)"list_item", null) == null;
        String[] hints = new String[]{"shortcut", "title"};
        SliceItem action = SliceQuery.find((Slice)slice, (String)"action", (String[])hints, null);
        List possiblePrimaries = SliceQuery.findAll((Slice)slice, (String)"slice", (String[])hints, null);
        if (!(isLoading || isEmpty || action != null || possiblePrimaries != null && !possiblePrimaries.isEmpty())) {
            throw new IllegalStateException("A slice requires a primary action; ensure one of your builders has called #setPrimaryAction with a valid SliceAction.");
        }
        if (this.mFirstRowChecked && !this.mIsFirstRowTypeValid) {
            throw new IllegalStateException("A slice cannot have the first row be constructed from a GridRowBuilder, consider using #setHeader.");
        }
        if (this.mFirstRowChecked && !this.mFirstRowHasText) {
            throw new IllegalStateException("A slice requires the first row to have some text.");
        }
        return slice;
    }

    @Override
    public void addRow(@NonNull ListBuilder.RowBuilder builder) {
        RowBuilderImpl impl = new RowBuilderImpl(this.createChildBuilder());
        impl.fillFrom(builder);
        this.checkRow(true, impl.hasText());
        this.addRow(impl);
    }

    public void addRow(@NonNull RowBuilderImpl builder) {
        this.checkRow(true, builder.hasText());
        builder.getBuilder().addHints(new String[]{"list_item"});
        if (builder.isEndOfSection()) {
            builder.getBuilder().addHints(new String[]{"end_of_section"});
        }
        this.getBuilder().addSubSlice(builder.build());
    }

    @Override
    public void addGridRow(@NonNull GridRowBuilder builder) {
        this.checkRow(false, false);
        GridRowBuilderListV1Impl impl = new GridRowBuilderListV1Impl(this, builder);
        impl.getBuilder().addHints(new String[]{"list_item"});
        this.getBuilder().addSubSlice(impl.build());
    }

    @Override
    public void setHeader(@NonNull ListBuilder.HeaderBuilder builder) {
        this.mIsFirstRowTypeValid = true;
        this.mFirstRowHasText = true;
        this.mFirstRowChecked = true;
        HeaderBuilderImpl impl = new HeaderBuilderImpl(this);
        impl.fillFrom(builder);
        this.mSliceHeader = impl.build();
    }

    @Override
    public void addAction(@NonNull SliceAction action) {
        if (this.mSliceActions == null) {
            this.mSliceActions = new ArrayList<Slice>();
        }
        Slice.Builder b = new Slice.Builder(this.getBuilder()).addHints(new String[]{"actions"});
        this.mSliceActions.add(action.buildSlice(b));
    }

    @Override
    public void addRating(@NonNull ListBuilder.RatingBuilder builder) {
        RatingBuilderImpl impl = new RatingBuilderImpl(this.createChildBuilder(), builder);
        this.checkRow(true, impl.hasText());
        this.getBuilder().addSubSlice(impl.build(), "range");
    }

    @Override
    public void addInputRange(@NonNull ListBuilder.InputRangeBuilder builder) {
        InputRangeBuilderImpl impl = new InputRangeBuilderImpl(this.createChildBuilder(), builder);
        this.checkRow(true, impl.hasText());
        this.getBuilder().addSubSlice(impl.build(), "range");
    }

    @Override
    public void addRange(@NonNull ListBuilder.RangeBuilder builder) {
        RangeBuilderImpl impl = new RangeBuilderImpl(this.createChildBuilder(), builder);
        this.checkRow(true, impl.hasText());
        this.getBuilder().addSubSlice(impl.build(), "range");
    }

    @Override
    public void addSelection(@NonNull SelectionBuilder builder) {
        if (this.getSpec().canRender(SliceSpecs.LIST_V2)) {
            this.getBuilder().addSubSlice(new SelectionBuilderListV2Impl(this.createChildBuilder(), builder).build(), "selection");
        } else {
            this.getBuilder().addSubSlice(new SelectionBuilderBasicImpl(this.createChildBuilder(), builder).build());
        }
    }

    @Override
    public void setSeeMoreRow(@NonNull ListBuilder.RowBuilder builder) {
        RowBuilderImpl impl = new RowBuilderImpl(this.createChildBuilder());
        impl.fillFrom(builder);
        impl.getBuilder().addHints(new String[]{"see_more"});
        this.getBuilder().addSubSlice(impl.build());
    }

    @Override
    public void setSeeMoreAction(@NonNull PendingIntent intent) {
        this.getBuilder().addSubSlice(new Slice.Builder(this.getBuilder()).addHints(new String[]{"see_more"}).addAction(intent, new Slice.Builder(this.getBuilder()).addHints(new String[]{"see_more"}).build(), null).build());
    }

    @Override
    public void setColor(@ColorInt int color) {
        this.getBuilder().addInt(color, "color", new String[0]);
    }

    @Override
    public void setKeywords(@NonNull Set<String> keywords) {
        this.mKeywords = keywords;
    }

    @Override
    public void setTtl(long ttl) {
        long expiry = ttl == -1L ? -1L : this.getClock().currentTimeMillis() + ttl;
        this.getBuilder().addTimestamp(expiry, "millis", new String[]{"ttl"});
    }

    @Override
    @RequiresApi(value=26)
    public void setTtl(@Nullable Duration ttl) {
        this.setTtl(ttl == null ? -1L : ttl.toMillis());
    }

    @Override
    public void setIsError(boolean isError) {
        this.mIsError = isError;
    }

    @Override
    public void setLayoutDirection(int layoutDirection) {
        this.getBuilder().addInt(layoutDirection, "layout_direction", new String[0]);
    }

    @Override
    @RequiresApi(value=21)
    public void setHostExtras(@NonNull PersistableBundle extras) {
        this.mHostExtras = ConvertPersistableBundleApi21Impl.toBundle(extras);
    }

    private void checkRow(boolean isTypeValid, boolean hasText) {
        if (!this.mFirstRowChecked) {
            this.mFirstRowChecked = true;
            this.mIsFirstRowTypeValid = isTypeValid;
            this.mFirstRowHasText = hasText;
        }
    }

    public static class HeaderBuilderImpl
    extends TemplateBuilderImpl {
        private SliceItem mTitleItem;
        private SliceItem mSubtitleItem;
        private SliceItem mSummaryItem;
        private SliceAction mPrimaryAction;
        private CharSequence mContentDescr;

        HeaderBuilderImpl(@NonNull ListBuilderImpl parent) {
            super(parent.createChildBuilder(), null);
        }

        void fillFrom(ListBuilder.HeaderBuilder builder) {
            if (builder.getUri() != null) {
                this.setBuilder(new Slice.Builder(builder.getUri()));
            }
            this.setPrimaryAction(builder.getPrimaryAction());
            if (builder.getLayoutDirection() != -1) {
                this.setLayoutDirection(builder.getLayoutDirection());
            }
            if (builder.getTitle() != null || builder.isTitleLoading()) {
                this.setTitle(builder.getTitle(), builder.isTitleLoading());
            }
            if (builder.getSubtitle() != null || builder.isSubtitleLoading()) {
                this.setSubtitle(builder.getSubtitle(), builder.isSubtitleLoading());
            }
            if (builder.getSummary() != null || builder.isSummaryLoading()) {
                this.setSummary(builder.getSummary(), builder.isSummaryLoading());
            }
            if (builder.getContentDescription() != null) {
                this.setContentDescription(builder.getContentDescription());
            }
        }

        @Override
        public void apply(@NonNull Slice.Builder b) {
            if (this.mTitleItem != null) {
                b.addItem(this.mTitleItem);
            }
            if (this.mSubtitleItem != null) {
                b.addItem(this.mSubtitleItem);
            }
            if (this.mSummaryItem != null) {
                b.addItem(this.mSummaryItem);
            }
            if (this.mContentDescr != null) {
                b.addText(this.mContentDescr, "content_description", new String[0]);
            }
            if (this.mPrimaryAction != null) {
                this.mPrimaryAction.setPrimaryAction(b);
            }
            if (this.mSubtitleItem == null && this.mTitleItem == null) {
                throw new IllegalStateException("Header requires a title or subtitle to be set.");
            }
        }

        private void setTitle(CharSequence title, boolean isLoading) {
            this.mTitleItem = new SliceItem((Object)title, "text", null, new String[]{"title"});
            if (isLoading) {
                this.mTitleItem.addHint("partial");
            }
        }

        private void setSubtitle(CharSequence subtitle, boolean isLoading) {
            this.mSubtitleItem = new SliceItem((Object)subtitle, "text", null, new String[0]);
            if (isLoading) {
                this.mSubtitleItem.addHint("partial");
            }
        }

        private void setSummary(CharSequence summarySubtitle, boolean isLoading) {
            this.mSummaryItem = new SliceItem((Object)summarySubtitle, "text", null, new String[]{"summary"});
            if (isLoading) {
                this.mSummaryItem.addHint("partial");
            }
        }

        private void setPrimaryAction(SliceAction action) {
            this.mPrimaryAction = action;
        }

        private void setContentDescription(CharSequence description) {
            this.mContentDescr = description;
        }

        private void setLayoutDirection(int layoutDirection) {
            this.getBuilder().addInt(layoutDirection, "layout_direction", new String[0]);
        }
    }

    public static class RowBuilderImpl
    extends TemplateBuilderImpl {
        private boolean mIsEndOfSection;
        private SliceAction mPrimaryAction;
        private SliceItem mTitleItem;
        private SliceItem mSubtitleItem;
        private Slice mStartItem;
        private final ArrayList<Slice> mEndItems = new ArrayList();
        private CharSequence mContentDescr;

        RowBuilderImpl(Slice.Builder builder) {
            super(builder, null);
        }

        void fillFrom(ListBuilder.RowBuilder builder) {
            if (builder.getUri() != null) {
                this.setBuilder(new Slice.Builder(builder.getUri()));
            }
            this.setPrimaryAction(builder.getPrimaryAction());
            this.mIsEndOfSection = builder.isEndOfSection();
            if (builder.getLayoutDirection() != -1) {
                this.setLayoutDirection(builder.getLayoutDirection());
            }
            if (builder.getTitleAction() != null || builder.isTitleActionLoading()) {
                this.setTitleItem(builder.getTitleAction(), builder.isTitleActionLoading());
            } else if (builder.getTitleIcon() != null || builder.isTitleItemLoading()) {
                this.setTitleItem(builder.getTitleIcon(), builder.getTitleImageMode(), builder.isTitleItemLoading());
            } else if (builder.getTimeStamp() != -1L) {
                this.setTitleItem(builder.getTimeStamp());
            }
            if (builder.getTitle() != null || builder.isTitleLoading()) {
                this.setTitle(builder.getTitle(), builder.isTitleLoading());
            }
            if (builder.getSubtitle() != null || builder.isSubtitleLoading()) {
                this.setSubtitle(builder.getSubtitle(), builder.isSubtitleLoading());
            }
            if (builder.getContentDescription() != null) {
                this.setContentDescription(builder.getContentDescription());
            }
            List<Object> endItems = builder.getEndItems();
            List<Integer> endTypes = builder.getEndTypes();
            List<Boolean> endLoads = builder.getEndLoads();
            block5: for (int i = 0; i < endItems.size(); ++i) {
                switch (endTypes.get(i)) {
                    case 0: {
                        this.addEndItem((Long)endItems.get(i));
                        continue block5;
                    }
                    case 2: {
                        this.addEndItem((SliceAction)endItems.get(i), endLoads.get(i));
                        continue block5;
                    }
                    case 1: {
                        Pair pair = (Pair)endItems.get(i);
                        this.addEndItem((IconCompat)pair.first, (Integer)pair.second, endLoads.get(i));
                    }
                }
            }
        }

        private void setTitleItem(long timeStamp) {
            this.mStartItem = new Slice.Builder(this.getBuilder()).addTimestamp(timeStamp, null, new String[0]).addHints(new String[]{"title"}).build();
        }

        protected void setTitleItem(@NonNull IconCompat icon, int imageMode) {
            this.setTitleItem(icon, imageMode, false);
        }

        private void setTitleItem(@NonNull IconCompat icon, int imageMode, boolean isLoading) {
            Slice.Builder sb = new Slice.Builder(this.getBuilder()).addIcon(icon, null, this.parseImageMode(imageMode, isLoading));
            if (isLoading) {
                sb.addHints(new String[]{"partial"});
            }
            this.mStartItem = sb.addHints(new String[]{"title"}).build();
        }

        private void setTitleItem(@NonNull SliceAction action, boolean isLoading) {
            Slice.Builder sb = new Slice.Builder(this.getBuilder()).addHints(new String[]{"title"});
            if (isLoading) {
                sb.addHints(new String[]{"partial"});
            }
            this.mStartItem = action.buildSlice(sb);
        }

        private void setPrimaryAction(@NonNull SliceAction action) {
            this.mPrimaryAction = action;
        }

        private void setTitle(@NonNull CharSequence title, boolean isLoading) {
            this.mTitleItem = new SliceItem((Object)title, "text", null, new String[]{"title"});
            if (isLoading) {
                this.mTitleItem.addHint("partial");
            }
        }

        protected void setSubtitle(@NonNull CharSequence subtitle) {
            this.setSubtitle(subtitle, false);
        }

        private void setSubtitle(@NonNull CharSequence subtitle, boolean isLoading) {
            this.mSubtitleItem = new SliceItem((Object)subtitle, "text", null, new String[0]);
            if (isLoading) {
                this.mSubtitleItem.addHint("partial");
            }
        }

        protected void addEndItem(long timeStamp) {
            this.mEndItems.add(new Slice.Builder(this.getBuilder()).addTimestamp(timeStamp, null, new String[0]).build());
        }

        private void addEndItem(@NonNull IconCompat icon, int imageMode, boolean isLoading) {
            Slice.Builder sb = new Slice.Builder(this.getBuilder()).addIcon(icon, null, this.parseImageMode(imageMode, isLoading));
            if (isLoading) {
                sb.addHints(new String[]{"partial"});
            }
            this.mEndItems.add(sb.build());
        }

        private void addEndItem(@NonNull SliceAction action, boolean isLoading) {
            Slice.Builder sb = new Slice.Builder(this.getBuilder());
            if (isLoading) {
                sb.addHints(new String[]{"partial"});
            }
            this.mEndItems.add(action.buildSlice(sb));
        }

        private void setContentDescription(CharSequence description) {
            this.mContentDescr = description;
        }

        private void setLayoutDirection(int layoutDirection) {
            this.getBuilder().addInt(layoutDirection, "layout_direction", new String[0]);
        }

        public boolean isEndOfSection() {
            return this.mIsEndOfSection;
        }

        boolean hasText() {
            return this.mTitleItem != null || this.mSubtitleItem != null;
        }

        @Override
        public void apply(@NonNull Slice.Builder b) {
            if (this.mStartItem != null) {
                b.addSubSlice(this.mStartItem);
            }
            if (this.mTitleItem != null) {
                b.addItem(this.mTitleItem);
            }
            if (this.mSubtitleItem != null) {
                b.addItem(this.mSubtitleItem);
            }
            for (int i = 0; i < this.mEndItems.size(); ++i) {
                Slice item = this.mEndItems.get(i);
                b.addSubSlice(item);
            }
            if (this.mContentDescr != null) {
                b.addText(this.mContentDescr, "content_description", new String[0]);
            }
            if (this.mPrimaryAction != null) {
                this.mPrimaryAction.setPrimaryAction(b);
            }
        }
    }

    public static class RatingBuilderImpl
    extends TemplateBuilderImpl {
        private final PendingIntent mAction;
        protected int mMin = 0;
        protected int mMax = 100;
        protected int mValue = 0;
        @Nullable
        protected CharSequence mTitle;
        @Nullable
        protected CharSequence mSubtitle;
        @Nullable
        protected CharSequence mContentDescr;
        @Nullable
        protected SliceAction mPrimaryAction;
        protected boolean mValueSet = false;
        private Slice mStartItem;

        RatingBuilderImpl(Slice.Builder sb, ListBuilder.RatingBuilder builder) {
            super(sb, null);
            this.mValueSet = builder.isValueSet();
            this.mMin = builder.getMin();
            this.mMax = builder.getMax();
            this.mValue = (int)builder.getValue();
            this.mTitle = builder.getTitle();
            this.mSubtitle = builder.getSubtitle();
            this.mContentDescr = builder.getContentDescription();
            this.mPrimaryAction = builder.getPrimaryAction();
            this.mAction = builder.getInputAction();
            if (builder.getTitleIcon() != null) {
                this.setTitleItem(builder.getTitleIcon(), builder.getTitleImageMode(), builder.isTitleItemLoading());
            }
        }

        void setTitleItem(IconCompat icon, int imageMode, boolean isLoading) {
            Slice.Builder sb = new Slice.Builder(this.getBuilder()).addIcon(icon, null, this.parseImageMode(imageMode, isLoading));
            if (isLoading) {
                sb.addHints(new String[]{"partial"});
            }
            this.mStartItem = sb.addHints(new String[]{"title"}).build();
        }

        @Override
        public void apply(@NonNull Slice.Builder builder) {
            if (this.mAction == null) {
                throw new IllegalStateException("Star rating must have an associated action.");
            }
            if (!this.mValueSet) {
                this.mValue = this.mMin - 1;
            }
            if (this.mTitle != null) {
                builder.addText(this.mTitle, null, new String[]{"title"});
            }
            if (this.mSubtitle != null) {
                builder.addText(this.mSubtitle, null, new String[0]);
            }
            if (this.mContentDescr != null) {
                builder.addText(this.mContentDescr, "content_description", new String[0]);
            }
            if (this.mPrimaryAction != null) {
                this.mPrimaryAction.setPrimaryAction(builder);
            }
            if (this.mStartItem != null) {
                builder.addSubSlice(this.mStartItem);
            }
            Slice.Builder sb = new Slice.Builder(builder);
            sb.addHints(new String[]{"list_item"}).addInt(this.mMin, "min", new String[0]).addInt(this.mMax, "max", new String[0]).addInt(this.mValue, "value", new String[0]).addInt(2, "range_mode", new String[0]);
            builder.addAction(this.mAction, sb.build(), "range").addHints(new String[]{"list_item"});
        }

        boolean hasText() {
            return this.mTitle != null || this.mSubtitle != null;
        }
    }

    public static class InputRangeBuilderImpl
    extends RangeBuilderImpl {
        private final PendingIntent mAction;
        private final IconCompat mThumb;
        private Slice mStartItem;
        private final ArrayList<Slice> mEndItems = new ArrayList();

        InputRangeBuilderImpl(Slice.Builder sb, ListBuilder.InputRangeBuilder builder) {
            super(sb, (ListBuilder.RangeBuilder)null);
            this.mValueSet = builder.isValueSet();
            this.mMin = builder.getMin();
            this.mMax = builder.getMax();
            this.mValue = builder.getValue();
            this.mTitle = builder.getTitle();
            this.mSubtitle = builder.getSubtitle();
            this.mContentDescr = builder.getContentDescription();
            this.mPrimaryAction = builder.getPrimaryAction();
            this.mLayoutDir = builder.getLayoutDirection();
            this.mAction = builder.getInputAction();
            this.mThumb = builder.getThumb();
            if (builder.getTitleIcon() != null) {
                this.setTitleItem(builder.getTitleIcon(), builder.getTitleImageMode(), builder.isTitleItemLoading());
            }
            List<Object> endItems = builder.getEndItems();
            List<Integer> endTypes = builder.getEndTypes();
            List<Boolean> endLoads = builder.getEndLoads();
            for (int i = 0; i < endItems.size(); ++i) {
                if (endTypes.get(i) != 2) continue;
                this.addEndItem((SliceAction)endItems.get(i), endLoads.get(i));
            }
        }

        @Override
        void setTitleItem(IconCompat icon, int imageMode, boolean isLoading) {
            Slice.Builder sb = new Slice.Builder(this.getBuilder()).addIcon(icon, null, this.parseImageMode(imageMode, isLoading));
            if (isLoading) {
                sb.addHints(new String[]{"partial"});
            }
            this.mStartItem = sb.addHints(new String[]{"title"}).build();
        }

        private void addEndItem(@NonNull SliceAction action, boolean isLoading) {
            Slice.Builder sb = new Slice.Builder(this.getBuilder());
            if (isLoading) {
                sb.addHints(new String[]{"partial"});
            }
            this.mEndItems.add(action.buildSlice(sb));
        }

        @Override
        public void apply(@NonNull Slice.Builder builder) {
            if (this.mAction == null) {
                throw new IllegalStateException("Input ranges must have an associated action.");
            }
            Slice.Builder sb = new Slice.Builder(builder);
            super.apply(sb);
            if (this.mThumb != null) {
                sb.addIcon(this.mThumb, null, new String[0]);
            }
            builder.addAction(this.mAction, sb.build(), "range").addHints(new String[]{"list_item"});
            if (this.mStartItem != null) {
                builder.addSubSlice(this.mStartItem);
            }
            for (int i = 0; i < this.mEndItems.size(); ++i) {
                builder.addSubSlice(this.mEndItems.get(i));
            }
        }
    }

    public static class RangeBuilderImpl
    extends TemplateBuilderImpl {
        protected int mMin = 0;
        protected int mMax = 100;
        protected int mValue = 0;
        protected boolean mValueSet = false;
        @Nullable
        protected CharSequence mTitle;
        @Nullable
        protected CharSequence mSubtitle;
        @Nullable
        protected CharSequence mContentDescr;
        @Nullable
        protected SliceAction mPrimaryAction;
        protected int mLayoutDir = -1;
        private int mMode = 0;
        private Slice mStartItem;

        RangeBuilderImpl(Slice.Builder sb, ListBuilder.RangeBuilder builder) {
            super(sb, null);
            if (builder != null) {
                this.mValueSet = builder.isValueSet();
                this.mMax = builder.getMax();
                this.mValue = builder.getValue();
                this.mTitle = builder.getTitle();
                this.mSubtitle = builder.getSubtitle();
                this.mContentDescr = builder.getContentDescription();
                this.mPrimaryAction = builder.getPrimaryAction();
                this.mLayoutDir = builder.getLayoutDirection();
                this.mMode = builder.getMode();
                if (builder.getTitleIcon() != null) {
                    this.setTitleItem(builder.getTitleIcon(), builder.getTitleImageMode(), builder.isTitleItemLoading());
                }
            }
        }

        void setTitleItem(IconCompat icon, int imageMode, boolean isLoading) {
            Slice.Builder sb = new Slice.Builder(this.getBuilder()).addIcon(icon, null, this.parseImageMode(imageMode, isLoading));
            if (isLoading) {
                sb.addHints(new String[]{"partial"});
            }
            this.mStartItem = sb.addHints(new String[]{"title"}).build();
        }

        @Override
        public void apply(@NonNull Slice.Builder builder) {
            if (!this.mValueSet) {
                this.mValue = this.mMin;
            }
            if (this.mMin > this.mValue || this.mValue > this.mMax || this.mMin >= this.mMax) {
                throw new IllegalArgumentException("Invalid range values, min=" + this.mMin + ", value=" + this.mValue + ", max=" + this.mMax + " ensure value falls within (min, max) and min < max.");
            }
            if (this.mStartItem != null) {
                builder.addSubSlice(this.mStartItem);
            }
            if (this.mTitle != null) {
                builder.addText(this.mTitle, null, new String[]{"title"});
            }
            if (this.mSubtitle != null) {
                builder.addText(this.mSubtitle, null, new String[0]);
            }
            if (this.mContentDescr != null) {
                builder.addText(this.mContentDescr, "content_description", new String[0]);
            }
            if (this.mPrimaryAction != null) {
                this.mPrimaryAction.setPrimaryAction(builder);
            }
            if (this.mLayoutDir != -1) {
                builder.addInt(this.mLayoutDir, "layout_direction", new String[0]);
            }
            builder.addHints(new String[]{"list_item"}).addInt(this.mMin, "min", new String[0]).addInt(this.mMax, "max", new String[0]).addInt(this.mValue, "value", new String[0]).addInt(this.mMode, "range_mode", new String[0]);
        }

        boolean hasText() {
            return this.mTitle != null || this.mSubtitle != null;
        }
    }

    @RequiresApi(value=21)
    private static class ConvertPersistableBundleApi21Impl {
        private ConvertPersistableBundleApi21Impl() {
        }

        static Bundle toBundle(@NonNull PersistableBundle extras) {
            return new Bundle(extras);
        }
    }
}

