/*
 * Decompiled with CFR 0.152.
 */
package androidx.slice.builders.impl;

import android.graphics.drawable.Icon;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.graphics.drawable.IconCompat;
import androidx.slice.Slice;
import androidx.slice.SliceSpec;
import androidx.slice.builders.impl.MessagingBuilder;
import androidx.slice.builders.impl.TemplateBuilderImpl;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@RequiresApi(value=19)
public class MessagingBasicImpl
extends TemplateBuilderImpl
implements MessagingBuilder {
    private MessageBuilder mLastMessage;

    public MessagingBasicImpl(Slice.Builder builder, SliceSpec spec) {
        super(builder, spec);
    }

    @Override
    public void apply(@NonNull Slice.Builder builder) {
        if (this.mLastMessage != null) {
            Slice.Builder sb = new Slice.Builder(this.getBuilder()).addHints(new String[]{"list_item"});
            if (Build.VERSION.SDK_INT >= 23 && this.mLastMessage.mIcon != null) {
                sb.addSubSlice(this.mLastMessage.mIcon);
            }
            if (this.mLastMessage.mText != null) {
                sb.addText(this.mLastMessage.mText, null, new String[0]);
            }
            builder.addSubSlice(sb.build());
        }
    }

    @Override
    public void add(TemplateBuilderImpl builder) {
        MessageBuilder b = (MessageBuilder)builder;
        if (this.mLastMessage == null || this.mLastMessage.mTimestamp < b.mTimestamp) {
            this.mLastMessage = b;
        }
    }

    @Override
    public TemplateBuilderImpl createMessageBuilder() {
        return new MessageBuilder(this);
    }

    public static final class MessageBuilder
    extends TemplateBuilderImpl
    implements MessagingBuilder.MessageBuilder {
        @RequiresApi(value=23)
        Slice mIcon;
        CharSequence mText;
        long mTimestamp;

        public MessageBuilder(MessagingBasicImpl parent) {
            this(parent.createChildBuilder());
        }

        private MessageBuilder(Slice.Builder builder) {
            super(builder, null);
        }

        @Override
        @RequiresApi(value=23)
        public void addSource(Icon source) {
            this.mIcon = this.getBuilder().addIcon(IconCompat.createFromIcon((Icon)source), "source", new String[]{"no_tint"}).addHints(new String[]{"title"}).build();
        }

        @Override
        public void addText(CharSequence text) {
            this.mText = text;
        }

        @Override
        public void addTimestamp(long timestamp) {
            this.mTimestamp = timestamp;
        }

        @Override
        public void apply(@NonNull Slice.Builder builder) {
        }
    }
}

