/*
 * Decompiled with CFR 0.152.
 */
package androidx.slice.builders.impl;

import android.graphics.drawable.Icon;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.graphics.drawable.IconCompat;
import androidx.slice.Slice;
import androidx.slice.SliceSpec;
import androidx.slice.builders.impl.ListBuilderImpl;
import androidx.slice.builders.impl.MessagingBuilder;
import androidx.slice.builders.impl.TemplateBuilderImpl;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@RequiresApi(value=19)
public class MessagingListV1Impl
extends TemplateBuilderImpl
implements MessagingBuilder {
    private final ListBuilderImpl mListBuilder;

    public MessagingListV1Impl(Slice.Builder b, SliceSpec spec) {
        super(b, spec);
        this.mListBuilder = new ListBuilderImpl(b, spec);
        this.mListBuilder.setTtl(-1L);
    }

    @Override
    public void add(TemplateBuilderImpl builder) {
        MessageBuilder b = (MessageBuilder)builder;
        this.mListBuilder.addRow(b.mListBuilder);
    }

    @Override
    public TemplateBuilderImpl createMessageBuilder() {
        return new MessageBuilder(this);
    }

    @Override
    public void apply(@NonNull Slice.Builder builder) {
        this.mListBuilder.apply(builder);
    }

    public static final class MessageBuilder
    extends TemplateBuilderImpl
    implements MessagingBuilder.MessageBuilder {
        final ListBuilderImpl.RowBuilderImpl mListBuilder;

        public MessageBuilder(MessagingListV1Impl parent) {
            this(parent.createChildBuilder());
        }

        private MessageBuilder(Slice.Builder builder) {
            super(builder, null);
            this.mListBuilder = new ListBuilderImpl.RowBuilderImpl(builder);
        }

        @Override
        @RequiresApi(value=23)
        public void addSource(Icon source) {
            this.mListBuilder.setTitleItem(IconCompat.createFromIcon((Icon)source), 1);
        }

        @Override
        public void addText(CharSequence text) {
            this.mListBuilder.setSubtitle(text);
        }

        @Override
        public void addTimestamp(long timestamp) {
            this.mListBuilder.addEndItem(timestamp);
        }

        @Override
        public void apply(@NonNull Slice.Builder builder) {
            this.mListBuilder.apply(builder);
        }
    }
}

