/*
 * Decompiled with CFR 0.152.
 */
package androidx.slice.builders.impl;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.util.Pair;
import androidx.slice.Slice;
import androidx.slice.builders.SelectionBuilder;
import androidx.slice.builders.impl.SelectionBuilderImpl;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@RequiresApi(value=19)
public class SelectionBuilderListV2Impl
extends SelectionBuilderImpl {
    public SelectionBuilderListV2Impl(Slice.Builder parentSliceBuilder, SelectionBuilder selectionBuilder) {
        super(parentSliceBuilder, selectionBuilder);
    }

    @Override
    public void apply(@NonNull Slice.Builder sliceBuilder) {
        Slice.Builder actionBuilder = new Slice.Builder(sliceBuilder);
        SelectionBuilder selectionBuilder = this.getSelectionBuilder();
        selectionBuilder.check();
        if (selectionBuilder.getTitle() != null) {
            actionBuilder.addText(selectionBuilder.getTitle(), null, new String[]{"title"});
        }
        if (selectionBuilder.getSubtitle() != null) {
            actionBuilder.addText(selectionBuilder.getSubtitle(), null, new String[0]);
        }
        if (selectionBuilder.getContentDescription() != null) {
            actionBuilder.addText(selectionBuilder.getContentDescription(), "content_description", new String[0]);
        }
        if (selectionBuilder.getLayoutDirection() != -1) {
            actionBuilder.addInt(selectionBuilder.getLayoutDirection(), "layout_direction", new String[0]);
        }
        List<Pair<String, CharSequence>> options = selectionBuilder.getOptions();
        for (Pair<String, CharSequence> option : options) {
            Slice.Builder optionSubSliceBuilder = new Slice.Builder(sliceBuilder);
            if (((String)option.first).equals(selectionBuilder.getSelectedOption())) {
                optionSubSliceBuilder.addHints(new String[]{"selected"});
            }
            optionSubSliceBuilder.addText((CharSequence)option.first, "selection_option_key", new String[0]);
            optionSubSliceBuilder.addText((CharSequence)option.second, "selection_option_value", new String[0]);
            optionSubSliceBuilder.addHints(new String[]{"selection_option"});
            actionBuilder.addSubSlice(optionSubSliceBuilder.build());
        }
        selectionBuilder.getPrimaryAction().setPrimaryAction(actionBuilder);
        sliceBuilder.addAction(selectionBuilder.getInputAction(), actionBuilder.build(), "selection");
        sliceBuilder.addHints(new String[]{"list_item"});
    }
}

