/*
 * Decompiled with CFR 0.152.
 */
package androidx.slice.builders.impl;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.slice.Clock;
import androidx.slice.Slice;
import androidx.slice.SliceSpec;
import androidx.slice.SystemClock;
import java.util.ArrayList;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@RequiresApi(value=19)
public abstract class TemplateBuilderImpl {
    private Slice.Builder mSliceBuilder;
    private final SliceSpec mSpec;
    private Clock mClock;

    protected TemplateBuilderImpl(Slice.Builder b, SliceSpec spec) {
        this(b, spec, (Clock)new SystemClock());
    }

    protected TemplateBuilderImpl(Slice.Builder b, SliceSpec spec, Clock clock) {
        this.mSliceBuilder = b;
        this.mSpec = spec;
        this.mClock = clock;
    }

    protected void setBuilder(Slice.Builder builder) {
        this.mSliceBuilder = builder;
    }

    public Slice build() {
        this.mSliceBuilder.setSpec(this.mSpec);
        this.apply(this.mSliceBuilder);
        return this.mSliceBuilder.build();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public Slice.Builder getBuilder() {
        return this.mSliceBuilder;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public Slice.Builder createChildBuilder() {
        return new Slice.Builder(this.mSliceBuilder);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public abstract void apply(@NonNull Slice.Builder var1);

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public Clock getClock() {
        return this.mClock;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public SliceSpec getSpec() {
        return this.mSpec;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    protected ArrayList<String> parseImageMode(int imageMode, boolean isLoading) {
        ArrayList<String> hints = new ArrayList<String>();
        if (imageMode == 6) {
            hints.add("show_label");
        }
        if (imageMode != 0) {
            hints.add("no_tint");
        }
        if (imageMode == 2 || imageMode == 4) {
            hints.add("large");
        }
        if (imageMode == 3 || imageMode == 4) {
            hints.add("raw");
        }
        if (isLoading) {
            hints.add("partial");
        }
        return hints;
    }
}

