/*
 * Create a huge and holey shared mapping, in the expectation that
 * page_launder() will do writepage()s on it.
 */

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/mman.h>
#include "slacker.h"

int main(int argc, char *argv[])
{
	int fd;
	loff_t size;
	char *filename;
	char c = 1;
	void *mapped_mem;
	long *p, val;
	loff_t idx;

	if (argc != 3) {
		fprintf(stderr, "Usage; %s filename size\n", argv[0]);
		exit(1);
	}

	filename = argv[1];
	fd = open(filename, O_RDWR|O_TRUNC|O_CREAT, 0666);
	if (fd < 0) {
		fprintf(stderr, "%s: Cannot open `%s': %s\n",
			argv[0], filename, strerror(errno));
		exit(1);
	}

	sscanf(argv[2], "%Ld", &size);
	printf("%s: expanding `%s' to size %Ld\n", argv[0], filename, size);
	if (pwrite(fd, &c, 1, size - 1) != 1) {
		perror("pwrite");
		exit(1);
	}
	mapped_mem = mmap(0, size, PROT_READ|PROT_WRITE, MAP_SHARED, fd, 0);
	if (mapped_mem == MAP_FAILED) {
		perror("mmap");
		exit(1);
	}
	printf("dirtying %Ld bytes of memory\n", size);
	val = 0;
	p = mapped_mem;
	for (idx = 0; idx < size / sizeof(*p); idx++) {
		p[idx] = val++;
	}
	printf("sleeping\n");
	for ( ; ; )
		sleep(1000);
	exit(0);
}
