/*
 * Force final blocks in file to be written via writepage()
 */

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/mman.h>

int main(int argc, char *argv[])
{
	int fd;
	loff_t size = 4096*16;
	char *filename;
	void *mapped_mem;

	if (argc != 2) {
		fprintf(stderr, "Usage; %s filename\n", argv[0]);
		exit(1);
	}

	filename = argv[1];
	fd = open(filename, O_RDWR|O_TRUNC|O_CREAT, 0666);
	if (fd < 0) {
		fprintf(stderr, "%s: Cannot open `%s': %s\n",
			argv[0], filename, strerror(errno));
		exit(1);
	}

	printf("%s: expanding `%s' to size %Ld\n", argv[0], filename, size);
	if (ftruncate(fd, size) < 0) {
		perror("ftruncate");
		exit(1);
	}
	mapped_mem = mmap(0, size, PROT_READ|PROT_WRITE, MAP_SHARED, fd, 0);
	if (mapped_mem == MAP_FAILED) {
		perror("mmap");
		exit(1);
	}
	printf("dirtying %Ld bytes of memory\n", size);
	memset(mapped_mem, 0, size);
	msync(mapped_mem, size, MS_SYNC);
	exit(0);
}
