/*
 * The test case that forced arjan to write the O(1) VM.
 * Reimplemented by Rik van Riel because the code given to Arjan
 * didn't have any license so it couldn't be freely distributed.
 *
 * (C) 2002 Rik van Riel
 * Released under the General Public License (GPL)
 *
 * <arjan> I can summarize it in pseudocode tho
 * <arjan> writing it back into c is like trivial
 * <arjan> ok have an array of (char) pointers of say 2000 entries
 * <arjan> allocate 1MB of memory for every slot in the array
 * <arjan> (with malloc)
 * <arjan> then phase 1:
 * <arjan> iterate over the array, memcpy( array[i],array[i+1], 1Gb)
 * <arjan> (eg dirty all 2Gb of memory)
 * <arjan> then phase 2:
 * <arjan> for (10 minutes of time) {
 * <arjan> take 2 random values  < 2000
 * <arjan> memcpy(array[value1], array[value2], 1Gb);
 * <arjan> }
 * <arjan> and then free the memory again and exit
 *
 * <arjan> this thing btw is more fun if you run more than 1
 * <arjan> because then the second process will steal ALL free memory
 *         while the first one is sleeping
 * <arjan> THAT makes it tough on the VM more than anything
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <getopt.h>

#define BLOCKSIZE (1024 * 1024)

char *progname;

char *memblocks[64000];
int opt_niters = 5000;
int opt_numblocks = 1024;

void alloc_mem(void)
{
	int i;
	printf("Allocating %d blocks of %d bytes\n", opt_numblocks, BLOCKSIZE);
	for (i = 0; i < opt_numblocks; i++) {
		char * mem = malloc(BLOCKSIZE);
		if (!mem) {
			printf("Couldn't allocate all memory, sorry...\n");
			exit(1);
		}
		memblocks[i] = mem;
	}
}

void dirty_all_mem(void)
{
	int i, j;
	printf("Dirtying memory\n");
	for (i = 0; i < opt_numblocks; i++) {
		j = (i + 1) % opt_numblocks;
		memcpy(memblocks[i], memblocks[j], BLOCKSIZE);
	}
}

void random_copy(void)
{
	int rand1, rand2;
	int n;

	printf("Doing random 1MB memcpy\n");
	for (n = 0; n < opt_niters; n++) {
		rand1 = random() % opt_numblocks;
		rand2 = random() % opt_numblocks;

		memcpy(memblocks[rand1], memblocks[rand2], BLOCKSIZE);
		if (n % 100 == 0)
			printf("%d/%d\n", n, opt_niters);
	}
}

void free_all(void)
{
	int i;
	printf("Freeing memory\n");
	for (i = 0; i < opt_numblocks; i++)
		free(memblocks[i]);
}

void usage(void)
{
	fprintf(stderr, "Usage: %s [-mM] [-nN]\n", progname);
	fprintf(stderr, "     -nN:         Run N iterations\n"); 
	fprintf(stderr, "     -mN:         Use N megabytes\n"); 
	exit(1);
}

int main(int argc, char *argv[])
{
	int c;

	progname = argv[0];
	while ((c = getopt(argc, argv, "m:n:")) != -1) {
		switch (c) {
		case 'm':
			opt_numblocks = strtol(optarg, NULL, 10);
			break;
		case 'n':
			opt_niters = strtol(optarg, NULL, 10);
			break;
		default:
			usage();
		}
	}

	if (optind != argc)
		usage();

	alloc_mem();

	dirty_all_mem();

	random_copy();

	free_all();
	exit(0);
}
