#!/bin/sh

MEMTOTAL=$(grep MemTotal /proc/meminfo | sed -e 's/[^0-9]*\([0-9]*\).*/\1/')
THREADS=$(grep processor /proc/cpuinfo | wc -l)
FILE=./foo

if [ $# -eq 1 ]
then
	FILE=$1
fi

echo Using file $FILE

# This is in kbytes
MEMTOTAL=$(expr $MEMTOTAL \* 4 / 2)

# Can't malloc more than two gigs...
if [ $MEMTOTAL -gt 2000000 ]
then
	MEMTOTAL=2000000
fi

while true
do
	usemem -m $(expr $MEMTOTAL / 1000) &
	usemem -m $(expr $MEMTOTAL / 1000)
done &

bash-shared-mapping $FILE $(expr $MEMTOTAL \* 1000) -t $THREADS

